import ui, net, app, grp, wndMgr, chr, playerSettingModule, localeInfo, snd, musicInfo, systemSetting

PLAYER_SLOT_COUNT = 4

BLACKLIST = ["LEVANA"]


PLAYER_VALUES = {
	0 : 0,
	1 : 5,
	2 : 2,
	3 : 7,
	4 : 4,
	5 : 1,
	6 : 6,
	7 : 3,
}

names = {
	0 : {
			"name" : "Razboinic", 
			"desc" : [
				"Datorita competentelor,",
				"armelor si abilitatii lor",
				"de a purta armuri grele",
				"ei joaca un rol important",
				"in lupta de aproape."
			],},
	1 : {
			"name" : "Ninja", 
			"desc" : [
				"Ninja sunt asasini profesionisti,",
				"ei pot ataca prin ambuscada.",
				"Poarta numai armuri usoare",
				"pentru a mentine viteza",
				"si mobilitatea."
			],},
	2 : {
			"name" : "Sura", 
			"desc" : [
				"Sura sunt Luptatorii care",
				"au obtinut puteri magice",
				"cand au decis sa creasca in",
				"bratele lor Samburii",
				"malefici ai Raului. "
			],},
	3 : {
			"name" : "Saman", 
			"desc" : [
				"Samanii sunt caractere versatile,",
				"bazate pe magie, putand provoca",
				"daune mari cu ajutorul magiilor",
				"ofensive si in acelasi timp,",
				"imbunatatindu-si capabilitatile proprii."
			],},
}


class CreateCharacterWindow(ui.ScriptWindow):

	START_STAT =	(  ## CON INT STR DEX
						[ 4, 3, 6, 3, ], ## Warrior
						[ 3, 3, 4, 6, ], ## Assassin
						[ 3, 5, 5, 3, ], ## Sura
						[ 4, 6, 3, 3, ], ## Shaman
						[ 4, 3, 6, 3, ], ## Warrior
						[ 3, 3, 4, 6, ], ## Assassin
						[ 3, 5, 5, 3, ], ## Sura
						[ 4, 6, 3, 3, ], ## Shaman
					)

	class CharacterRenderer(ui.Window):
		def OnRender(self):
			grp.ClearDepthBuffer()
			grp.SetGameRenderState()
			grp.PushState()
			grp.SetOmniLight()
			grp.SetViewport(0.50, 0.0, 0.5, 1.0)
			
			app.SetCenterPosition(0.0, 0.0, 0.0)
			app.SetCamera(1550.0, 15.0, 180.0, 95.0)
			grp.SetPerspective(10.0, (float(wndMgr.GetScreenWidth()) / 2.0 / float(wndMgr.GetScreenHeight())), 1000.0, 3000.0)

			(x, y) = app.GetCursorPosition()
			grp.SetCursorPosition(x, y)

			chr.Deform()
			chr.Render()

			grp.RestoreViewport()
			grp.PopState()
			grp.SetInterfaceRenderState()

	def __init__(self, stream = None):
		ui.ScriptWindow.__init__(self)
		self.stream = stream
		playerSettingModule.LoadGameData("INIT")
		net.SetPhaseWindow(net.PHASE_WINDOW_CREATE, self)
		self.__LoadScript("levana_work/code/ui_levana_create.py")
		self.rotation = 0
		self.current_slot = 0
		self.female_add = 0
		self.shapeIndex = 0
		self.reservingRaceIndex = -1
		self.is_female = FALSE
		self.Open()
				
	def __del__(self):
		ui.ScriptWindow.__del__(self)
		net.SetPhaseWindow(net.PHASE_WINDOW_CREATE, 0)
		
	def Open(self):
		playerSettingModule.LoadGameData("INIT")
		app.SetCamera(500.0, 10.0, 180.0, 95.0)
		self.Show()

		if musicInfo.createMusic != "":
			snd.SetMusicVolume(systemSetting.GetMusicVolume())
			snd.FadeInMusic("BGM/"+musicInfo.createMusic)

		app.ShowCursor()
		self.__SelectSlot(0)

	def Close(self):
		self.edit_name.Enable()
		self.stream=0

		if musicInfo.createMusic != "":
			snd.FadeOutMusic("BGM/"+musicInfo.createMusic)

		chr.DeleteInstance(0)

		self.Hide()

		app.HideCursor()

	def __LoadScript(self, fileName):
		try:
			pyLoader = ui.PythonScriptLoader()
			pyLoader.LoadScriptFile(self, fileName)
		except:
			import exception
			exception.Abort("levana_select.py ## __LoadScript.LoadScriptFile")
		try:
			self.edit_name		= self.GetChild("edit_name")
			self.content_create		= self.GetChild("content_create")
			self.btn_create		= self.GetChild("btn_create")
			self.btn_left		= self.GetChild("btn_left")
			self.btn_right		= self.GetChild("btn_right")
			self.img_race		= self.GetChild("img_race")
			self.edit_name.SetMax(16)
			self.gender_btn = {
				0 : self.GetChild("btn_gender_01"),
				1 : self.GetChild("btn_gender_02"),
			}
			self.shape_btn = {
				0 : self.GetChild("btn_shape_01"),
				1 : self.GetChild("btn_shape_02"),
			}
			
			self.texts = {
				0 : self.GetChild("text_desc_01"),
				1 : self.GetChild("text_desc_02"),
				2 : self.GetChild("text_desc_03"),
				3 : self.GetChild("text_desc_04"),
				4 : self.GetChild("text_desc_05"),
			}
			
			self.character_render_window		= self.GetChild("character_render_window")

			self.chrRenderer = self.CharacterRenderer()
			self.chrRenderer.SetParent(self.character_render_window)
			self.chrRenderer.Show()
		except:
			import exception
			exception.Abort("levana_select.py ## __LoadScript.GetChild")
		try:
			self.btn_create.SetEvent(ui.__mem_func__(self.__CreateCharacter))
			self.btn_right.SetEvent(ui.__mem_func__(self.__SelectSlot), 1)
			self.btn_left.SetEvent(ui.__mem_func__(self.__SelectSlot), -1)
			for i in range(len(self.gender_btn)):
				self.gender_btn[i].SetEvent(ui.__mem_func__(self.__ChangeGender),i)
			for i in range(len(self.shape_btn)):
				self.shape_btn[i].SetEvent(ui.__mem_func__(self.__ChangeShape),i)
			self.edit_name.SetReturnEvent(ui.__mem_func__(self.__CreateCharacter))
			self.edit_name.SetEscapeEvent(ui.__mem_func__(self.CancelCreate))
		except:
			import exception
			exception.Abort("levana_select.py ## __LoadScript.SetEvent")

	def __Close(self):
		self.CancelCreate()
						
	def __ChangeGender(self, id):
		for i in range(len(self.gender_btn)):
			self.gender_btn[i].SetUp()
		self.gender_btn[id].Down()
		if id == 0:
			self.is_female = TRUE
		else:
			self.is_female = FALSE
		self.__SelectSlot(self.current_slot)
				
	def __ChangeShape(self, id):
		for i in range(len(self.shape_btn)):
			self.shape_btn[i].SetUp()
		self.shape_btn[id].Down()
		chr.ChangeShape(id)
		chr.SetMotionMode(chr.MOTION_MODE_GENERAL)
		chr.SetLoopMotion(chr.MOTION_INTRO_WAIT)
		self.shapeIndex = id
				
	def __MakeCharacter(self, race):
		chr.CreateInstance(0)
		chr.SelectInstance(0)
		chr.SetVirtualID(0)
		chr.SetNameString("")

		chr.SetRace(race)
		chr.SetArmor(0)
		chr.SetHair(0)

		chr.Refresh()
		chr.SetMotionMode(chr.MOTION_MODE_GENERAL)
		chr.SetLoopMotion(chr.MOTION_INTRO_WAIT)

		chr.SetRotation(0.0)
		
	def __SelectSlot(self, slot):
		if (self.current_slot + slot) < 0:
			self.current_slot = 3
		elif (self.current_slot + slot) > 3:
			self.current_slot = 0
		else:
			self.current_slot += slot
		chr.DeleteInstance(0)
		if self.is_female:
			self.female_add = 4
		else:
			self.female_add = 0
		chr.DeleteInstance(0)
		for i in range(len(self.texts)):
			self.texts[i].SetText(names[self.current_slot]["desc"][i])
		self.__MakeCharacter(PLAYER_VALUES[self.current_slot + self.female_add])
		self.__ChangeShape(0)
		
		raceImgDict = {
			0 : "levana_work/images/select/img_race_warrior.tga",
			1 : "levana_work/images/select/img_race_ninja.tga",
			2 : "levana_work/images/select/img_race_sura.tga",
			3 : "levana_work/images/select/img_race_shaman.tga",
			4 : "levana_work/images/select/img_race_warrior.tga",
			5 : "levana_work/images/select/img_race_ninja.tga",
			6 : "levana_work/images/select/img_race_sura.tga",
			7 : "levana_work/images/select/img_race_shaman.tga",
		}
		
		self.img_race.LoadImage(raceImgDict[self.current_slot + self.female_add])
		
	def OnKeyDown(self, key):
		if 203 == key:
			self.__SelectSlot(-1)
		if 205 == key:
			self.__SelectSlot(1)
		if 28 == key:
			self.__CreateCharacter()

		return TRUE
		
	def __CreateCharacter(self):
		self.DisableWindow()
		textName = self.edit_name.GetText()
		if FALSE == self.__CheckCreateCharacter(textName):
			return
		if musicInfo.selectMusic != "":
			snd.FadeLimitOutMusic("BGM/"+musicInfo.selectMusic, systemSetting.GetMusicVolume()*0.05)
		self.reservingStartTime = app.GetTime()
		self.reservingRaceIndex = chr.GetRace()
		chr.PushOnceMotion(chr.MOTION_INTRO_SELECTED)
			
	def __CheckCreateCharacter(self, name):
		if len(name) == 0:
			self.PopupMessage(localeInfo.CREATE_INPUT_NAME, self.EnableWindow)
			return FALSE

		if name.find(localeInfo.CREATE_GM_NAME)!=-1:
			self.PopupMessage(localeInfo.CREATE_ERROR_GM_NAME, self.EnableWindow)
			return FALSE

		if net.IsInsultIn(name):
			self.PopupMessage(localeInfo.CREATE_ERROR_INSULT_NAME, self.EnableWindow)
			return FALSE
			

		if name.upper() in BLACKLIST:
			self.PopupMessage("Teamlernamen nicht erlaubt!", self.EnableWindow)
			return FALSE

		return TRUE
		
	def EnableWindow(self):
		self.btn_create.Enable()
		self.gender_btn[0].Enable()
		self.gender_btn[1].Enable()
		self.shape_btn[0].Enable()
		self.shape_btn[1].Enable()
		self.edit_name.SetFocus()
		chr.BlendLoopMotion(chr.MOTION_INTRO_WAIT, 0.1)
		
	def DisableWindow(self):
		self.btn_create.Disable()
		self.gender_btn[0].Disable()
		self.gender_btn[1].Disable()
		self.shape_btn[0].Disable()
		self.shape_btn[1].Disable()
		self.edit_name.Disable()
		
	def OnCreateSuccess(self):
		self.stream.SetSelectCharacterPhase()
		# return

	def OnCreateFailure(self, type):
		if 1 == type:
			self.PopupMessage(localeInfo.CREATE_EXIST_SAME_NAME, self.EnableWindow)
		else:
			self.PopupMessage(localeInfo.CREATE_FAILURE, self.EnableWindow)
		
	def PopupMessage(self, msg, func=0):
		if not func:
			func=self.EmptyFunc

		self.stream.popupWindow.Close()
		self.stream.popupWindow.Open(msg, func, localeInfo.UI_OK)
			
	def EmptyFunc(self):
		pass
		
	def TestOutput(self, txt):
		import dbg
		dbg.TraceError("TESTOUTPUT :::: %s" % (txt))
	
	def OnPressExitKey(self):
		self.CancelCreate()
		
	def CancelCreate(self):
		self.stream.SetSelectCharacterPhase()
		# app.Exit()
		
	def OnUpdate(self):
		chr.Update()
		chr.SetRotation(self.rotation)
		self.rotation += 0.4
		
		if -1 != self.reservingRaceIndex:
			if app.GetTime() - self.reservingStartTime >= 1.5:

				chrSlot=self.stream.GetCharacterSlot()
				textName = self.edit_name.GetText()
				if self.is_female:
					self.female_add = 4
				else:
					self.female_add = 0
				net.SendCreateCharacterPacket(chrSlot, textName, PLAYER_VALUES[self.current_slot + self.female_add], self.shapeIndex, 0, 0, 0, 0)

				self.reservingRaceIndex = -1
